/*
 * Decompiled with CFR 0.152.
 */
package com.flanks255.simplybackpacks.network;

import com.flanks255.simplybackpacks.gui.FilterContainer;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;

public class FilterMessage {
    private final int opts;

    public FilterMessage(int opts) {
        this.opts = opts;
    }

    public static FilterMessage decode(FriendlyByteBuf buffer) {
        return new FilterMessage(buffer.readInt());
    }

    public static void encode(FilterMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.opts);
    }

    public static void handle(FilterMessage message, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection().getReceptionSide().isServer()) {
            ctx.get().enqueueWork(() -> {
                ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
                if (player != null && player.f_36096_ instanceof FilterContainer) {
                    ((FilterContainer)player.f_36096_).saveFilter(message.opts);
                }
            });
        }
        ctx.get().setPacketHandled(true);
    }
}

